---
title: 포트원 AI 챗봇이 반복되는 기술 문의를 획기적으로 단축한 비결
description: 잘 만든 AI 서비스 하나로 1000개의 기술 문의를 대신한 이야기
author: portone-io
date: 2025-12-17T15:00:00.000Z
tags:
  - AI
  - Chatbot
---

안녕하세요, 온라인 비즈니스 결제 인프라를 만드는 포트원입니다.
결제 연동은 복잡합니다. 개발 환경도 다르고, 사용하는 언어도 제각각이죠. 그러다 보니 포트원 CS 채널에는 하루에도
수많은 '기술 문의'가 쏟아집니다.
문제는 여기서 발생합니다. 고객의 질문은 고도화되는데, CS 담당자가 모든 개발 지식을 알 수는 없으니까요.
결국 문의는 개발팀으로 넘어오고, "문의 - CS팀 - 개발자 - 답변 작성 - CS팀 - 고객"으로 이어지는 비효율의
무한 루프가 시작됩니다.

**"이 단순 반복 업무를 AI가 대신할 수는 없을까?"**

최근 포트원이 공개한 AI 챗봇, ‘포트원 AI Assistant’ 프로젝트는 위 질문에서 시작되었습니다.
해커톤에서 시작된 실험을 실제 서비스로 안착시키기까지, 포트원의 한지환 프로덕트 오너와 전우제 백엔드 엔지니어가
함께한 치열했던 개발기를 공개합니다.

## ‘단순한 기술 문의의 반복, 어려워지는 온보딩’

포트원 개발팀은 단순한 기술 문의가 지속적으로 반복되며 개발자들이 CS답변에 쓰는 리소스가 점점 늘어나는 상황과,
결제 연동 과정에서 고객들이 길어지는 상담으로 이탈하는 문제를 발견했습니다.

한지환 프로덕트 오너 : 포트원의 미션은 '온라인 비즈니스를 하고 있는 누구나 결제 연동을 쉽게 하는 것'입니다. 그런데
아이러니하게도 연동 과정에서 고객들이 겪는 어려움을 해결해 주는 과정이 점점 느려졌어요. 기술 문의가 들어오면
CS팀에서 개발자에게 전달하고, 개발자가 내용을 확인하고 답변을 줄 때까지 고객은 기다려야 했죠. 내부적으로도 리소스
낭비가 심했습니다. 개발자들이 코드 짜는 시간보다 기술 문의 답변을 검수해 주는 시간이 점점 늘어나기 시작했거든요.

전우제 엔지니어 : 반복되는 기술 문의를 들여다보면 패턴이 보였어요. "결제 연동 오류가 나요"라고 하는데, 살펴보면
뻔한 실수인 경우가 많았죠. 개발자가 보면 1초 만에 아는 내용인데, CS팀을 거치다 보니 답변이 늦어지는 상황이
반복됐습니다. 이 시간을 단축하고 싶다는 니즈는 개발팀 내에서도 꽤 오래전부터 있었습니다

## 해커톤이 가져다준 AI 실험 기회

이 문제를 해결하기 위해 처음부터 거창한 프로젝트를 띄운 건 아니었습니다.
시작은 포트원 개발팀이 참여한 'AWS X 메가존 해커톤'이었습니다.

전우제 엔지니어 : 사실 이 아이디어가 해커톤 메인 출품작은 아니었어요.
하지만 해커톤 기간 동안 AWS Bedrock과 Claude 모델을 마음껏 테스트해 볼 수 있는 '크레딧'이 생겼다는 게 중요했습니다. 회사 입장에서 AI 도입의 가장 큰 장벽은 '비용'이거든요.

"이게 진짜 될까?" 싶은 아이디어를 비용 걱정 없이 검증해 볼 수 있는 완벽한 타이밍이었죠.
그때 얻은 'AI 서비스 구성 감각'이 실제 제품 개발로 이어지는 결정적인 트리거가 됐습니다.

## AI를 '답변 기계'가 아닌 '사고 파트너'로

가장 큰 기술적 난관은 AI 챗봇의 고질병인 '할루시네이션(거짓 답변)'이었습니다.
결제 연동 가이드에서 없는 함수를 있다고 하거나, 잘못된 파라미터를 알려주면 치명적이니까요.

보통은 이를 해결하기 위해 RAG(검색 증강 생성)와 Vector DB를 사용하지만,
포트원 개발팀은 조금 다른 접근을 택했습니다.

### Vector DB 없는 RAG? "MCP의 도입"

초기 테스트 결과, 단순히 문서를 쪼개서 Vector DB에 넣고 검색하는 방식은 한계가 명확했습니다. 문맥이 잘린 채
검색되다 보니 AI가 엉뚱한 문서를 참고해서 답변하는 경우가 많았죠.

그래서 우리는 MCP(Model Context Protocol) 개념을 적극적으로 도입했습니다.

쉽게 말해, AI에게 미리 정답지(문서 조각)를 쥐여주는 게 아니라, "네가 모르는 게 있으면
우리 개발자 문서 도구(Tool)를 사용해서 직접 검색해 봐"라고 시키는 방식입니다. AI를 단순 답변기가 아니라,
문서를 검색하고 내용을 판단하는 '사고 파트너(Thinking Partner)'로 설계한 것이죠.

### 비용과 성능의 줄타기 (Claude 4.0 Sonnet)

모델 선정도 치열했습니다. 성능이 좋은 모델은 비싸고, 싼 모델은 답변 품질이 다소 낮습니다.

비용 절감과 품질 사이에서 고민하다 결국 Claude 4.0 Sonnet을 채택했습니다. 저렴하지 않은 모델을 썼음에도 비용은
오히려 통제 가능했습니다.

- MCP 서버를 최적화하여 불필요한 토큰 소모를 줄였습니다.
- 답변의 정확도가 올라가니, 사용자가 여러 번 다시 묻는 횟수가 줄어들어 전체적인 토큰 사용량은 합리적인 수준(하루 100건 사용 기준 월 $25\~30 내외)으로 유지되었습니다.

### "기다림도 UX다"

(관련 이미지 첨부)

LLM의 답변 속도를 우리가 직접 획기적으로 줄이는 건 불가능했죠. 대신 이용자 입장에서의
'체감 시간'을 줄이려고 했습니다.
단순히 로딩 바가 도는 게 아니라, "현재 개발자 문서를 검색하고 있습니다...", "관련 내용을 분석 중입니다..." 처럼
AI가 현재 수행 중인 작업을 실시간으로 보여주었습니다. (Perplexity나 Gemini처럼요.) 이 작은 장치가 고객이
이탈하지 않고 답변을 기다리게 만드는 핵심 UX가 되었습니다.

## AI 챗봇 도입 성과 : "CS 문의가 줄었습니다"

(관련 이미지 첨부)

포트원 AI 챗봇 도입 3주 차, 변화는 데이터로 나타나고 있습니다.

한지환 프로덕트 오너 : CS팀에서 먼저 피드백이 왔어요. "체감상 기술 문의가 확 줄었다"고요. 하루 평균 약 50\~100건
정도의 문의를 AI가 처리하고 있습니다. 도입 후 약 1,000건의 문의를 처리했죠. 특히 "API 키 어디서 찾나요?",
"이 오류 코드는 뭔가요?" 같은 단순 문의는 AI 챗봇 선에서 대부분 해결됩니다.

재미있는 건 개발자들의 반응입니다. "CS팀에서 넘어오는 기술 문의 난이도가 올라갔다"고 해요.

전우제 엔지니어 : 예전엔 "뭐가 안 돼요"라는 단순한 질문이 왔다면, 이제는 AI를 통해 1차적인 해결을 시도해 본
고객들이 "AI 챗봇을 보고 여기까지 해봤는데, 이 부분에서 막힙니다"라고 구체적인 질문을 던집니다.

비효율적인 핑퐁이 사라지고, 개발자와 CS팀 모두가 '진짜 해결해야 할 문제'에 집중할 수 있게 된 것입니다.

## 포트원의 다음 미션 : "결제 연동, 클릭 한 번으로 해결"

포트원 AI Assistant는 이제 시작입니다. 포트원은 '단순히 질문을 답변해주는 봇'을 넘어 '결제를 직접 연동하는
에이전트(Agent)'를 꿈꿉니다.

한지환 프로덕트 오너 : 지금은 "PG 어떻게 연동해요?"라고 물으면 방법을 알려주죠. 하지만 포트원이 준비하는
다음 단계는 그 이상입니다. 고객의 깃허브(Github)를 AI가 분석하고, 프로젝트 환경에 맞는 결제 연동 코드를 직접
짜서 PR(Pull Request)까지 날려주는 단계. 이미 PoC(개념 검증)는 마쳤고 개발이 진행 중입니다.

개발자가 더 이상 단순 반복 업무에 시달리지 않는 세상, 누구나 말 한마디로 결제를 연동하는 세상.

포트원의 ‘AI를 활용한 결제 연동 경험 혁신’은 이제 막 본궤도에 올랐습니다.
